//GEMINI-pro DATASET v1.0 Category: Time Travel Simulator ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_HISTORY 100

typedef struct {
    time_t timestamp;
    char *message;
} TimeTravelLogEntry;

TimeTravelLogEntry history[MAX_HISTORY];
int history_index = 0;

void log_event(char *message) {
    history[history_index].timestamp = time(NULL);
    history[history_index].message = message;
    history_index++;
    if (history_index == MAX_HISTORY) {
        history_index = 0;
    }
}

void print_history() {
    for (int i = 0; i < MAX_HISTORY; i++) {
        if (history[i].timestamp != 0) {
            printf("%s: %s\n", ctime(&history[i].timestamp), history[i].message);
        }
    }
}

int main() {
    log_event("Hello, world!");
    sleep(1);
    log_event("I am a time traveler.");
    sleep(1);
    log_event("I have come from the future.");
    sleep(1);
    log_event("To warn you of the dangers that lie ahead.");
    sleep(1);
    log_event("The future is not what you think it is.");
    sleep(1);
    log_event("It is a dark and dangerous place.");
    sleep(1);
    log_event("But you can still change it.");
    sleep(1);
    log_event("You have the power to create a better future.");
    sleep(1);
    log_event("So don't give up hope.");
    sleep(1);
    log_event("Fight for what you believe in.");
    sleep(1);
    log_event("And never let go of your dreams.");

    print_history();

    return 0;
}