//LLAMA2-13B DATASET v1.0 Category: Task Scheduler ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>

#define MAX_TASKS 10
#define MAX_DELAY 300

struct task {
    int pid;
    int delay;
    char *name;
};

void add_task(struct task *tasks, int num_tasks, char *name, int delay) {
    int i;
    for (i = 0; i < num_tasks; i++) {
        if (tasks[i].pid == 0) {
            tasks[i].pid = fork();
            if (tasks[i].pid == 0) {
                // Child process
                break;
            } else {
                // Parent process
                tasks[i].pid = tasks[i].pid;
            }
        }
        if (tasks[i].pid > 0) {
            // Already scheduled, ignore
            return;
        }
    }
    // No available slots, return error
    if (i == num_tasks) {
        return;
    }
    tasks[i].pid = fork();
    if (tasks[i].pid == 0) {
        // Child process
        tasks[i].delay = delay;
        tasks[i].name = name;
        printf("Added task: %s with delay %d\n", name, delay);
    } else {
        // Parent process
        tasks[i].pid = tasks[i].pid;
    }
}

void schedule(struct task *tasks, int num_tasks) {
    int i;
    for (i = 0; i < num_tasks; i++) {
        if (tasks[i].pid > 0) {
            // Already running, skip
            continue;
        }
        // Schedule task
        tasks[i].pid = fork();
        if (tasks[i].pid == 0) {
            // Child process
            tasks[i].delay = tasks[i].delay;
            tasks[i].name = tasks[i].name;
            printf("Scheduled task: %s with delay %d\n", tasks[i].name, tasks[i].delay);
        } else {
            // Parent process
            tasks[i].pid = tasks[i].pid;
        }
        break;
    }
}

int main() {
    struct task tasks[MAX_TASKS];
    int num_tasks = 0;

    // Example tasks
    tasks[num_tasks].name = "Task 1";
    tasks[num_tasks].delay = 100;
    num_tasks++;

    tasks[num_tasks].name = "Task 2";
    tasks[num_tasks].delay = 200;
    num_tasks++;

    tasks[num_tasks].name = "Task 3";
    tasks[num_tasks].delay = 300;
    num_tasks++;

    // Schedule tasks
    schedule(tasks, num_tasks);

    // Wait for tasks to complete
    wait(NULL);

    return 0;
}