//MISTRAL-7B DATASET v1.0 Category: Networking ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 51
#define HEIGHT 21

typedef struct { int x, y; } point;

void maze_generate(int maze[WIDTH][HEIGHT]);
void recursive_backtracking(int maze[WIDTH][HEIGHT], point current, int visited[][WIDTH]);

int main() {
    int maze[WIDTH][HEIGHT];
    point start = { 1, 1 };
    int visited[WIDTH][WIDTH] = { 0 };

    srand(time(NULL));
    maze_generate(maze);
    recursive_backtracking(maze, start, visited);

    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            if (x == 0 || x == WIDTH - 1)
                printf("%c%3c", x == 0 ? '|' : ' ', x == WIDTH - 1 ? '-' : ' ');
            else
                printf("%c", maze[x][y] == 0 ? ' ' : '#');
        }
        printf("\n");
    }

    return 0;
}

void maze_generate(int maze[WIDTH][HEIGHT]) {
    for (int y = 0; y < HEIGHT; y++)
        for (int x = 0; x < WIDTH; x++)
            maze[x][y] = rand() % 2;
}

void recursive_backtracking(int maze[WIDTH][HEIGHT], point current, int visited[WIDTH][WIDTH]) {
    visited[current.x][current.y] = 1;

    int dx[4] = { -1, 0, 1, 1 };
    int dy[4] = { -1, 1, 1, 0 };

    for (int i = 0; i < 4; i++) {
        int next_x = current.x + dx[i];
        int next_y = current.y + dy[i];

        if (next_x >= 0 && next_x < WIDTH && next_y >= 0 && next_y < HEIGHT &&
            maze[next_x][next_y] == 0 && visited[next_x][next_y] == 0) {
            maze[current.x][current.y] = 1;
            recursive_backtracking(maze, (point) { next_x, next_y }, visited);
        }
    }
}