//Gemma-7B DATASET v1.0 Category: Procedural Space Adventure ; Style: visionary
#include <stdio.h>
#include <stdlib.h>

void traverse_galaxy(int x, int y)
{
    // Galactic map
    char galaxy[10][10] = {
        {'S', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
        {' ', 'O', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
        {' ', ' ', 'R', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
        {' ', ' ', ' ', 'T', ' ', ' ', ' ', ' ', ' ', ' '},
        {' ', ' ', ' ', ' ', 'E', ' ', ' ', ' ', ' ', ' '},
        {' ', ' ', ' ', ' ', ' ', 'H', ' ', ' ', ' ', ' '},
        {' ', ' ', ' ', ' ', ' ', ' ', 'C', ' ', ' ', ' '},
        {' ', ' ', ' ', ' ', ' ', ' ', ' ', 'R', ' ', ' '},
        {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'S', ' '},
        {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '}
    };

    // Travel directions
    int dx[] = {1, 0, -1, 0};
    int dy[] = {0, 1, 0, -1};

    // Explore the galaxy
    for (int i = 0; i < 4; i++)
    {
        int new_x = x + dx[i];
        int new_y = y + dy[i];

        // Check if the new position is within the bounds of the galaxy
        if (new_x >= 0 && new_x < 10 && new_y >= 0 && new_y < 10)
        {
            // If the position is not a star, print the symbol at that location
            if (galaxy[new_x][new_y] != ' ')
            {
                printf("%c ", galaxy[new_x][new_y]);
            }
        }
    }

    // Print a newline
    printf("\n");
}

int main()
{
    // Traverse the galaxy at coordinates (5, 5)
    traverse_galaxy(5, 5);

    return 0;
}