//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_Cars 10
#define Road_Length 20

typedef struct Car {
  int position;
  int direction;
  int speed;
} Car;

Car cars[MAX_Cars];

void InitializeCars() {
  for (int i = 0; i < MAX_Cars; i++) {
    cars[i].position = rand() % Road_Length;
    cars[i].direction = rand() % 2;  // Left or right
    cars[i].speed = rand() % 5 + 1;
  }
}

void MoveCars() {
  for (int i = 0; i < MAX_Cars; i++) {
    switch (cars[i].direction) {
      case 0:
        cars[i].position++;
        break;
      case 1:
        cars[i].position--;
        break;
    }

    if (cars[i].position >= Road_Length) {
      cars[i].position = 0;
      cars[i].direction = rand() % 2;
    } else if (cars[i].position <= 0) {
      cars[i].position = Road_Length - 1;
      cars[i].direction = rand() % 2;
    }
  }
}

int main() {
  InitializeCars();
  MoveCars();

  return 0;
}