//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

// Define the port number for the server
#define PORT 8080

// Create a TCP socket
int create_socket() {
    int sockfd;
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        exit(EXIT_FAILURE);
    }
    return sockfd;
}

// Bind the socket to the specified port
void bind_socket(int sockfd, struct sockaddr_in *addr) {
    if (bind(sockfd, (struct sockaddr *)addr, sizeof(*addr)) == -1) {
        perror("bind");
        exit(EXIT_FAILURE);
    }
}

// Listen for incoming connections
void listen_for_connections(int sockfd) {
    if (listen(sockfd, 5) == -1) {
        perror("listen");
        exit(EXIT_FAILURE);
    }
}

// Accept an incoming connection
int accept_connection(int sockfd) {
    int newsockfd;
    struct sockaddr_in cliaddr;
    socklen_t clilen = sizeof(cliaddr);
    newsockfd = accept(sockfd, (struct sockaddr *)&cliaddr, &clilen);
    if (newsockfd == -1) {
        perror("accept");
        exit(EXIT_FAILURE);
    }
    return newsockfd;
}

// Send data to the client
void send_data(int sockfd, char *data, int len) {
    if (send(sockfd, data, len, 0) == -1) {
        perror("send");
        exit(EXIT_FAILURE);
    }
}

// Receive data from the client
int receive_data(int sockfd, char *buffer, int len) {
    int n;
    n = recv(sockfd, buffer, len, 0);
    if (n == -1) {
        perror("recv");
        exit(EXIT_FAILURE);
    }
    return n;
}

// Close the socket
void close_socket(int sockfd) {
    close(sockfd);
}

// Main function
int main() {
    int sockfd, newsockfd;
    struct sockaddr_in addr;
    char buffer[256];
    int n;

    // Create a TCP socket
    sockfd = create_socket();

    // Bind the socket to the specified port
    addr.sin_family = AF_INET;
    addr.sin_port = htons(PORT);
    addr.sin_addr.s_addr = INADDR_ANY;
    bind_socket(sockfd, &addr);

    // Listen for incoming connections
    listen_for_connections(sockfd);

    // Accept an incoming connection
    newsockfd = accept_connection(sockfd);

    // Receive data from the client
    n = receive_data(newsockfd, buffer, 256);
    if (n > 0) {
        printf("Received data from the client: %s\n", buffer);
    }

    // Send data to the client
    strcpy(buffer, "Hello, world!");
    send_data(newsockfd, buffer, strlen(buffer));

    // Close the socket
    close_socket(newsockfd);
    close_socket(sockfd);

    return 0;
}