//Falcon-180B DATASET v1.0 Category: Threading Library Implementation ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

// Define the maximum number of threads
#define MAX_THREADS 5

// Define the thread data structure
typedef struct {
    int id;
    void *(*func)(void *);
    void *data;
} thread_data_t;

// Define the thread function prototype
void *thread_func(void *data);

// Define the main function
int main() {
    pthread_t threads[MAX_THREADS];
    thread_data_t thread_data[MAX_THREADS];
    int i;

    // Initialize the thread data
    for (i = 0; i < MAX_THREADS; i++) {
        thread_data[i].id = i;
        thread_data[i].func = &thread_func;
        thread_data[i].data = (void *)i;
    }

    // Create the threads
    for (i = 0; i < MAX_THREADS; i++) {
        if (pthread_create(&threads[i], NULL, &thread_func, (void *)&thread_data[i])!= 0) {
            printf("Error creating thread %d\n", i);
            exit(1);
        }
    }

    // Join the threads
    for (i = 0; i < MAX_THREADS; i++) {
        if (pthread_join(threads[i], NULL)!= 0) {
            printf("Error joining thread %d\n", i);
            exit(1);
        }
    }

    return 0;
}

// Define the thread function
void *thread_func(void *data) {
    int id = *(int *)data;
    printf("Thread %d is running\n", id);
    return NULL;
}