//Falcon-180B DATASET v1.0 Category: Tower of Hanoi Problem ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#define NUM_DISKS 5

// Struct to hold disk information
typedef struct {
    int disk_size;
    int disk_num;
    int from_rod;
    int to_rod;
} disk_t;

// Function prototypes
void move_disk(disk_t *disk);
void print_disks(disk_t disks[], int num_disks);

// Global variables
disk_t disks[NUM_DISKS];
int num_disks = NUM_DISKS;
int source_rod = 0;
int dest_rod = 2;
int completed_moves = 0;

// Function to move a disk from one rod to another
void move_disk(disk_t *disk) {
    printf("Moving disk %d from rod %d to rod %d...\n", disk->disk_num, disk->from_rod, disk->to_rod);
    sleep(1); // Simulate disk movement time
    printf("Disk %d successfully moved to rod %d.\n", disk->disk_num, disk->to_rod);
}

// Function to print the current state of the disks
void print_disks(disk_t disks[], int num_disks) {
    for (int i = 0; i < num_disks; i++) {
        printf("Disk %d is on rod %d.\n", disks[i].disk_num, disks[i].from_rod);
    }
}

// Function to solve the Tower of Hanoi problem
void* solve_tower_of_hanoi(void *arg) {
    int num_moves = 0;
    while (num_moves < (NUM_DISKS - 1)) {
        move_disk(&disks[num_moves]);
        num_moves++;
    }
    pthread_exit(0);
}

// Main function
int main() {
    int i;

    // Initialize disk information
    for (i = 0; i < NUM_DISKS; i++) {
        disks[i].disk_size = i + 1;
        disks[i].disk_num = i + 1;
        disks[i].from_rod = source_rod;
        disks[i].to_rod = dest_rod;
    }

    // Create threads to solve the problem
    pthread_t threads[NUM_DISKS - 1];
    for (i = 0; i < NUM_DISKS - 1; i++) {
        pthread_create(&threads[i], NULL, solve_tower_of_hanoi, NULL);
    }

    // Wait for threads to complete
    for (i = 0; i < NUM_DISKS - 1; i++) {
        pthread_join(threads[i], NULL);
    }

    printf("Tower of Hanoi problem solved in %d moves.\n", completed_moves);
    return 0;
}