//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Declare the weather types
typedef enum {
    SUNNY,
    CLOUDY,
    RAINY,
    SNOWY
} weather_type;

// Declare the weather struct
typedef struct {
    weather_type type;
    int temperature;
    int humidity;
    int wind_speed;
} weather;

// Generate a random weather forecast
weather generate_forecast() {
    // Seed the random number generator
    srand(time(NULL));

    // Generate a random weather type
    weather_type type = rand() % 4;

    // Generate a random temperature
    int temperature = rand() % 100;

    // Generate a random humidity
    int humidity = rand() % 100;

    // Generate a random wind speed
    int wind_speed = rand() % 100;

    // Return the weather forecast
    return (weather){type, temperature, humidity, wind_speed};
}

// Print the weather forecast
void print_forecast(weather forecast) {
    // Print the weather type
    switch (forecast.type) {
        case SUNNY:
            printf("The weather forecast is sunny.");
            break;
        case CLOUDY:
            printf("The weather forecast is cloudy.");
            break;
        case RAINY:
            printf("The weather forecast is rainy.");
            break;
        case SNOWY:
            printf("The weather forecast is snowy.");
            break;
    }

    // Print the temperature
    printf(" The temperature will be %d degrees Fahrenheit.", forecast.temperature);

    // Print the humidity
    printf(" The humidity will be %d%%.", forecast.humidity);

    // Print the wind speed
    printf(" The wind speed will be %d miles per hour.", forecast.wind_speed);
}

// Main function
int main() {
    // Generate a weather forecast
    weather forecast = generate_forecast();

    // Print the weather forecast
    print_forecast(forecast);

    return 0;
}