//GPT-4o-mini DATASET v1.0 Category: Wi-Fi Signal Strength Analyzer ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <unistd.h>

#define MAX_NETWORKS 50
#define COMMAND_BUFFER 256
#define ESSID_LENGTH 32

typedef struct {
    char essid[ESSID_LENGTH];
    int quality;
} WifiNetwork;

WifiNetwork networks[MAX_NETWORKS];
int network_count = 0;

void* scan_wifi(void* arg) {
    FILE* fp;
    char command[COMMAND_BUFFER];

    // Command to run the 'iwlist' utility to scan for networks
    snprintf(command, sizeof(command), "iwlist wlan0 scan | grep 'ESSID\\|Quality' > wifi_scan.txt");
    system(command);

    // Open file to read the output of the command
    fp = fopen("wifi_scan.txt", "r");
    if (fp == NULL) {
        perror("Failed to open file");
        pthread_exit(NULL);
    }

    char line[COMMAND_BUFFER];
    while (fgets(line, sizeof(line), fp)) {
        char essid[ESSID_LENGTH];
        int quality;
        if (sscanf(line, " ESSID:\"%[^\"]\"", essid) == 1) {
            strncpy(networks[network_count].essid, essid, ESSID_LENGTH);
        }
        if (sscanf(line, " Quality=%d", &quality) == 1) {
            networks[network_count].quality = quality;
            network_count++;
            if (network_count >= MAX_NETWORKS) break;  // Avoid overflow
        }
    }

    fclose(fp);
    unlink("wifi_scan.txt"); // Clean up the command output file
    pthread_exit(NULL);
}

void display_results() {
    printf("Available Wi-Fi Networks:\n");
    printf("%-30s %s\n", "ESSID", "Quality");
    printf("%-30s %s\n", "------", "-------");

    for (int i = 0; i < network_count; i++) {
        printf("%-30s %d\n", networks[i].essid, networks[i].quality);
    }
}

int main() {
    pthread_t thread_id;

    // Start the Wi-Fi scanning in a separate thread
    if (pthread_create(&thread_id, NULL, scan_wifi, NULL) != 0) {
        perror("Failed to create thread");
        return EXIT_FAILURE;
    }

    // Let the main thread wait for the completion of scanning
    pthread_join(thread_id, NULL);
    
    // Displaying the results
    display_results();

    return EXIT_SUCCESS;
}