//MISTRAL-7B DATASET v1.0 Category: Fibonacci Sequence Visualizer ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <math.h>
#include <string.h>
#include <time.h>

#define MAX_FIB 50
typedef struct { float x, y; } point;

point heart_points[12];

void draw_heart() {
    int i;
    float twothirds = 1.6666;
    float two = 2.0;
    float width = 10;
    float height = (width * twothirds) * sqrt(3) / 2;

    heart_points[0].x = width / 2;
    heart_points[0].y = height;
    heart_points[1].x = width / 2 + (width / 3);
    heart_points[1].y = 0;
    heart_points[2].x = width / 2 + (width / 3) * twothirds;
    heart_points[2].y = height;

    for (i = 3; i < 12; i++) {
        heart_points[i].x = heart_points[i - 2].x + (heart_points[i - 2].x - heart_points[i - 1].x);
        heart_points[i].y = heart_points[i - 2].y + (heart_points[i - 2].y - heart_points[i - 1].y) * two;
    }
}

void print_point(point p) {
    printf("(%f, %f) ", p.x, p.y);
}

int main() {
    int fib_num = 0, fib_num_prev = 1, fib_num_next;
    int i, max_fib = MAX_FIB;
    bool print_heart = true;

    srand(time(NULL));

    printf("LoveFibs - A Romantic Fibonacci Sequence Visualizer\n");
    printf("------------------------------------------------\n");
    printf("Fibonacci numbers up to %d:\n", max_fib);

    draw_heart();
    printf("\nHeart points: ");

    fib_num_prev = 0;
    fib_num = 1;

    for (i = 0; i < max_fib; i++) {
        print_point((point){.x = fib_num_prev * 0.5, .y = fib_num * 0.5});

        if (i > 0) {
            fib_num_next = fib_num + fib_num_prev;
            fib_num = fib_num_next;
            fib_num_prev = fib_num_next - fib_num;
        }

        if (print_heart && i > 4 && i % 3 == 0) {
            printf("\n");
            printf("%s", "----------------------------------------------------------------------------------");
            printf("\n");
            printf("Heart points: ");
            print_heart = false;
        }
    }

    printf("\n");

    return EXIT_SUCCESS;
}