//GEMINI-pro DATASET v1.0 Category: Secure Password Generator ; Style: Alan Turing
#define _CRT_SECURE_NO_WARNINGS
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

// Function to generate a random character
char generate_random_character() {
  // ASCII values for lowercase letters: 97 - 122
  // ASCII values for uppercase letters: 65 - 90
  // ASCII values for digits: 48 - 57
  // ASCII values for special characters: 33 - 47, 58 - 64, 91 - 96, 123 - 126
  int random_ascii_value = rand() % (126 - 33 + 1) + 33;
  return (char)random_ascii_value;
}

// Function to generate a random password
char *generate_random_password(int length) {
  // Allocate memory for the password
  char *password = (char *)malloc(length + 1);
  if (password == NULL) {
    return NULL;
  }

  // Generate a random character for each position in the password
  for (int i = 0; i < length; i++) {
    password[i] = generate_random_character();
  }

  // Terminate the password with a null character
  password[length] = '\0';

  return password;
}

// Function to test the password generator
int main() {
  // Seed the random number generator
  srand(time(NULL));

  // Generate a random password of length 10
  char *password = generate_random_password(10);

  // Print the password
  printf("Generated password: %s\n", password);

  // Free the memory allocated for the password
  free(password);

  return 0;
}