//Gemma-7B DATASET v1.0 Category: Personal Finance Planner ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define the Personal Finance Planner structure
typedef struct PersonalFinancePlanner
{
    char name[50];
    int age;
    double income;
    double expenses;
    double savings;
    double investments;
    double net_worth;
} PersonalFinancePlanner;

// Function to calculate the net worth of a personal finance planner
double calculate_net_worth(PersonalFinancePlanner *planner)
{
    planner->net_worth = planner->savings + planner->investments - planner->expenses;
    return planner->net_worth;
}

// Function to display the personal finance planner information
void display_planner_information(PersonalFinancePlanner *planner)
{
    printf("Name: %s\n", planner->name);
    printf("Age: %d\n", planner->age);
    printf("Income: %.2lf\n", planner->income);
    printf("Expenses: %.2lf\n", planner->expenses);
    printf("Savings: %.2lf\n", planner->savings);
    printf("Investments: %.2lf\n", planner->investments);
    printf("Net Worth: %.2lf\n", calculate_net_worth(planner));
}

int main()
{
    // Create a personal finance planner
    PersonalFinancePlanner planner;

    // Initialize the personal finance planner information
    strcpy(planner.name, "John Doe");
    planner.age = 30;
    planner.income = 50000;
    planner.expenses = 15000;
    planner.savings = 20000;
    planner.investments = 30000;

    // Calculate the net worth of the personal finance planner
    calculate_net_worth(&planner);

    // Display the personal finance planner information
    display_planner_information(&planner);

    return 0;
}