//LLAMA2-13B DATASET v1.0 Category: File handling ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>

#define MAX_FILE_SIZE 1024 * 1024 * 100

int main(int argc, char *argv[]) {
    // Check if the user has provided a valid file name
    if (argc < 2) {
        printf("Error: Please provide a file name as an argument.\n");
        return 1;
    }

    // Open the file in read-only mode
    int fd = open(argv[1], O_RDONLY);
    if (fd == -1) {
        perror("Error: Unable to open file.");
        return 2;
    }

    // Get the file size
    struct stat file_stats;
    fstat(fd, &file_stats);
    long file_size = file_stats.st_size;

    // Check if the file size is within the maximum allowed size
    if (file_size > MAX_FILE_SIZE) {
        printf("Error: File size exceeds maximum allowed size of %ld MB.\n", MAX_FILE_SIZE / 1024 / 1024);
        close(fd);
        return 3;
    }

    // Mmap the file to memory
    void *file_ptr = mmap(NULL, file_size, PROT_READ, MAP_FILE | MAP_PRIVATE, fd, 0);
    if (file_ptr == MAP_FAILED) {
        perror("Error: Unable to mmap file to memory.");
        close(fd);
        return 4;
    }

    // Check if the file is a regular file
    if (S_ISREG(file_stats.st_mode)) {
        // Print the file contents
        printf("File contents: %s\n", file_ptr);
    } else {
        // Print an error message if the file is not a regular file
        printf("Error: File is not a regular file.");
    }

    // Unmap the file from memory
    munmap(file_ptr, file_size);

    // Close the file
    close(fd);

    return 0;
}