//Falcon-180B DATASET v1.0 Category: System boot optimizer ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_TOKENS 100
#define MAX_TOKEN_LEN 50

// Token structure
typedef struct {
    char *value;
    int length;
} Token;

// Function to tokenize a string
int tokenize(char *str, Token *tokens) {
    char *token = strtok(str, " \t\n\r\f\v");
    int count = 0;

    while (token!= NULL && count < MAX_TOKENS) {
        if (strlen(token) > MAX_TOKEN_LEN) {
            printf("Error: Token too long\n");
            exit(1);
        }

        tokens[count].value = token;
        tokens[count].length = strlen(token);

        count++;
        token = strtok(NULL, " \t\n\r\f\v");
    }

    return count;
}

// Function to execute a command
void execute_command(Token *tokens, int argc) {
    if (argc == 0) {
        printf("Error: No command specified\n");
        return;
    }

    char *command = tokens[0].value;

    if (strcmp(command, "exit") == 0) {
        exit(0);
    } else if (strcmp(command, "help") == 0) {
        printf("Commands:\n");
        printf("  exit - Exit the program\n");
        printf("  help - Display this help message\n");
    } else {
        printf("Error: Unknown command '%s'\n", command);
    }
}

// Function to parse and execute a line of input
void parse_line(char *line) {
    Token tokens[MAX_TOKENS];
    int argc = tokenize(line, tokens);

    if (argc == 0) {
        return;
    }

    execute_command(tokens, argc);
}

// Function to read a line of input
char *read_line() {
    char *line = NULL;
    size_t capacity = 0;

    getline(&line, &capacity, stdin);

    if (line == NULL) {
        printf("Error: Failed to read line\n");
        exit(1);
    }

    return line;
}

// Main program loop
int main() {
    while (1) {
        char *line = read_line();
        parse_line(line);

        free(line);
    }

    return 0;
}