//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: calm
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define MIN_PASSWORD_LENGTH 8
#define MAX_PASSWORD_LENGTH 32

int main() {
    char password[MAX_PASSWORD_LENGTH + 1];
    int length;
    int uppercase_count = 0;
    int lowercase_count = 0;
    int digit_count = 0;
    int special_char_count = 0;
    int total_count = 0;

    printf("Enter your password: ");
    fgets(password, MAX_PASSWORD_LENGTH + 1, stdin);
    length = strlen(password);

    if (length < MIN_PASSWORD_LENGTH || length > MAX_PASSWORD_LENGTH) {
        printf("Password must be between %d and %d characters long.\n", MIN_PASSWORD_LENGTH, MAX_PASSWORD_LENGTH);
        return 1;
    }

    for (int i = 0; i < length; i++) {
        if (isupper(password[i])) {
            uppercase_count++;
        } else if (islower(password[i])) {
            lowercase_count++;
        } else if (isdigit(password[i])) {
            digit_count++;
        } else if (isalpha(password[i])) {
            special_char_count++;
        }
    }

    total_count = uppercase_count + lowercase_count + digit_count + special_char_count;

    if (total_count == 0) {
        printf("Password must contain at least one uppercase letter, one lowercase letter, one digit, and one special character.\n");
        return 1;
    }

    if (length < 12) {
        printf("Password strength: Weak\n");
    } else if (length >= 12 && length < 16) {
        printf("Password strength: Medium\n");
    } else {
        printf("Password strength: Strong\n");
    }

    return 0;
}