//Falcon-180B DATASET v1.0 Category: Pac-Man Game Clone ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 21
#define HEIGHT 11
#define BOX_SIZE 3

enum {
    EMPTY = '.',
    WALL = '#',
    PILL = 'o',
    PACMAN = 'P',
    GHOST = 'G'
};

void init_maze(char maze[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            maze[i][j] = WALL;
        }
    }
    maze[0][0] = EMPTY;
    maze[HEIGHT - 1][WIDTH - 1] = EMPTY;
}

void draw_maze(const char maze[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            printf("%c", maze[i][j]);
        }
        printf("\n");
    }
}

int rand_in_range(int min, int max) {
    return rand() % (max - min + 1) + min;
}

int main() {
    srand(time(0));
    char maze[HEIGHT][WIDTH];
    init_maze(maze);
    for (int i = 0; i < 10; i++) {
        int x = rand_in_range(0, HEIGHT - 1);
        int y = rand_in_range(0, WIDTH - 1);
        if (maze[x][y] == WALL) {
            maze[x][y] = PILL;
        }
    }
    draw_maze(maze);
    return 0;
}