//Gemma-7B DATASET v1.0 Category: Sentiment analysis tool ; Style: Linus Torvalds
#include <stdio.h>
#include <string.h>

int main()
{
    char str[] = "This is a positive sentiment text.";
    int sentiment = sentiment_analysis(str);

    switch (sentiment)
    {
        case 1:
            printf("The text has a positive sentiment.\n");
            break;
        case 0:
            printf("The text has a neutral sentiment.\n");
            break;
        case -1:
            printf("The text has a negative sentiment.\n");
            break;
    }

    return 0;
}

int sentiment_analysis(char *str)
{
    // Count the number of positive words in the text.
    int num_positive = count_positive_words(str);

    // Count the number of negative words in the text.
    int num_negative = count_negative_words(str);

    // Calculate the sentiment score.
    int sentiment = (num_positive - num_negative) / 2;

    return sentiment;
}

int count_positive_words(char *str)
{
    char *words[] = {"good", "happy", "excellent", "great", "wonderful"};
    int i = 0;
    int num_positive = 0;

    for (i = 0; i < 5; i++)
    {
        if (strstr(str, words[i]) != NULL)
        {
            num_positive++;
        }
    }

    return num_positive;
}

int count_negative_words(char *str)
{
    char *words[] = {"bad", "sad", "terrible", "awful", "horrible"};
    int i = 0;
    int num_negative = 0;

    for (i = 0; i < 5; i++)
    {
        if (strstr(str, words[i]) != NULL)
        {
            num_negative++;
        }
    }

    return num_negative;
}