//Falcon2-11B DATASET v1.0 Category: Temperature monitor ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <linux/i2c-dev.h>

#define I2C_BUS 1
#define SLAVE_ADDR 0x48

int main()
{
    int fd, ret;
    struct stat st;
    char filename[] = "/dev/i2c-1";

    if (stat(filename, &st) < 0) {
        perror("Could not open file");
        return -1;
    }

    fd = open(filename, O_RDWR);

    if (fd < 0) {
        perror("Could not open file");
        return -1;
    }

    ret = ioctl(fd, I2C_SLAVE, SLAVE_ADDR);

    if (ret < 0) {
        perror("Could not read sensor");
        return -1;
    }

    float tempC;

    ret = read(fd, &tempC, sizeof(float));

    if (ret < 0) {
        perror("Could not read sensor");
        return -1;
    }

    printf("Temperature (in Celsius): %.2f degrees\n", tempC);

    close(fd);

    return 0;
}