//GEMINI-pro DATASET v1.0 Category: Fitness Tracker ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Our curious fitness tracker!

// Constants for activity levels
#define SEDENTARY 0
#define LIGHT 1
#define MODERATE 2
#define VIGOROUS 3

// Function to simulate a day's activity
int simulateActivity() {
  // Randomly generate an activity level
  int activityLevel = rand() % 4;

  // Simulate the activity for a day
  switch (activityLevel) {
    case SEDENTARY:
      printf("You spent the day sitting on the couch, watching TV.\n");
      break;
    case LIGHT:
      printf("You spent the day doing light activities, like walking or gardening.\n");
      break;
    case MODERATE:
      printf("You spent the day doing moderate activities, like jogging or dancing.\n");
      break;
    case VIGOROUS:
      printf("You spent the day doing vigorous activities, like running or playing sports.\n");
      break;
  }

  // Return the activity level
  return activityLevel;
}

int main() {
  // Seed the random number generator
  srand(time(NULL));

  // Simulate a month's worth of activity
  int totalActivityLevel = 0;
  for (int i = 0; i < 30; i++) {
    totalActivityLevel += simulateActivity();
  }

  // Calculate the average activity level
  float averageActivityLevel = (float)totalActivityLevel / 30;

  // Print the average activity level
  printf("Your average activity level for the month was %f.\n", averageActivityLevel);

  // Give the user some feedback
  if (averageActivityLevel < 1.5) {
    printf("You need to get more active! Aim for at least 150 minutes of moderate-intensity activity or 75 minutes of vigorous-intensity activity per week.\n");
  } else if (averageActivityLevel < 2.5) {
    printf("You're on the right track! Keep up the good work.\n");
  } else {
    printf("Congratulations! You're exceeding the recommended activity levels.\n");
  }

  return 0;
}