//Falcon-180B DATASET v1.0 Category: Traffic Light Controller ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#define GREEN 1
#define YELLOW 2
#define RED 3
#define PED_REQUEST 4
#define MAX_PED_WAIT 10
#define PED_WAIT_TIME 3
#define MAX_CYCLES 10
#define CYCLE_TIME 7

int main() {
    int state = GREEN;
    int cycle_count = 0;
    int ped_wait_count = 0;
    int ped_request = 0;
    srand(time(NULL));
    while (cycle_count < MAX_CYCLES) {
        printf("Current state: ");
        switch (state) {
            case GREEN:
                printf("Green\n");
                break;
            case YELLOW:
                printf("Yellow\n");
                break;
            case RED:
                printf("Red\n");
                break;
            case PED_REQUEST:
                printf("Pedestrian Request\n");
                break;
            default:
                printf("Invalid state\n");
                break;
        }
        if (state == GREEN || state == PED_REQUEST) {
            state = YELLOW;
        } else if (state == YELLOW) {
            state = RED;
        } else if (state == RED) {
            state = GREEN;
        }
        if (state == PED_REQUEST) {
            ped_wait_count++;
            if (ped_wait_count >= MAX_PED_WAIT) {
                printf("Pedestrian crossing\n");
                ped_wait_count = 0;
                ped_request = 0;
            }
        }
        usleep(CYCLE_TIME * 1000000);
        cycle_count++;
    }
    return 0;
}