//Gemma-7B DATASET v1.0 Category: Network Ping Test ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

#define SERVER_PORT 8080
#define NUM_PINGS 10

int main()
{
    int sockfd, ping_cnt = 0, send_len, recv_len;
    char ping_msg[] = "Ping!";
    struct sockaddr_in server_addr;

    // Create a socket
    sockfd = socket(AF_INET, SOCK_DGRAM, htons(SERVER_PORT));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    // Set up the server address
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(SERVER_PORT);
    server_addr.sin_addr.s_addr = inet_addr("192.168.1.1");

    // Send and receive pings
    for (ping_cnt = 0; ping_cnt < NUM_PINGS; ping_cnt++)
    {
        // Send the ping message
        send_len = sendto(sockfd, ping_msg, sizeof(ping_msg), 0, (struct sockaddr *)&server_addr, sizeof(server_addr));
        if (send_len < 0)
        {
            perror("Error sending ping");
            exit(1);
        }

        // Receive the ping reply
        recv_len = recvfrom(sockfd, ping_msg, sizeof(ping_msg), 0, (struct sockaddr *)&server_addr, NULL);
        if (recv_len < 0)
        {
            perror("Error receiving ping reply");
            exit(1);
        }

        // Print the ping reply
        printf("Ping reply: %s\n", ping_msg);
    }

    // Close the socket
    close(sockfd);

    return 0;
}