//Falcon-180B DATASET v1.0 Category: Error handling ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#define MAX_ERRORS 20
#define ERROR_MSG_LEN 256

typedef struct {
    const char *file;
    int line;
    const char *func;
    const char *msg;
} error_t;

static int error_count = 0;
static error_t errors[MAX_ERRORS];

void log_error(const char *file, int line, const char *func, const char *fmt,...) {
    if (error_count >= MAX_ERRORS) {
        fprintf(stderr, "Error: Too many errors, stopping logging.\n");
        return;
    }

    va_list ap;
    va_start(ap, fmt);
    vsnprintf(errors[error_count].msg, ERROR_MSG_LEN, fmt, ap);
    va_end(ap);

    errors[error_count].file = file;
    errors[error_count].line = line;
    errors[error_count].func = func;

    error_count++;
}

void print_errors() {
    if (error_count == 0) {
        printf("No errors.\n");
        return;
    }

    printf("Errors:\n");
    for (int i = 0; i < error_count; i++) {
        printf("%s:%d in %s(): %s\n", errors[i].file, errors[i].line, errors[i].func, errors[i].msg);
    }
}

int main() {
    log_error(__FILE__, __LINE__, __func__, "This is an example error message.");
    log_error(__FILE__, __LINE__, __func__, "Another example error message with %s and %d.", "format", 42);

    print_errors();

    return 0;
}