//GEMINI-pro DATASET v1.0 Category: Smart home light control ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the light states
enum light_state {
    OFF,
    ON,
    DIMMED
};

// Define the light structure
struct light {
    enum light_state state;
    int brightness;
};

// Create an array of lights
struct light lights[10];

// Initialize the lights
void initialize_lights() {
    for (int i = 0; i < 10; i++) {
        lights[i].state = OFF;
        lights[i].brightness = 0;
    }
}

// Turn on a light
void turn_on_light(int light_number) {
    if (light_number < 0 || light_number > 9) {
        printf("Invalid light number\n");
        return;
    }

    lights[light_number].state = ON;
    lights[light_number].brightness = 100;
}

// Turn off a light
void turn_off_light(int light_number) {
    if (light_number < 0 || light_number > 9) {
        printf("Invalid light number\n");
        return;
    }

    lights[light_number].state = OFF;
    lights[light_number].brightness = 0;
}

// Dim a light
void dim_light(int light_number, int brightness) {
    if (light_number < 0 || light_number > 9) {
        printf("Invalid light number\n");
        return;
    }

    if (brightness < 0 || brightness > 100) {
        printf("Invalid brightness\n");
        return;
    }

    lights[light_number].state = DIMMED;
    lights[light_number].brightness = brightness;
}

// Print the status of all lights
void print_lights_status() {
    for (int i = 0; i < 10; i++) {
        printf("Light %d: ", i);
        switch (lights[i].state) {
            case OFF:
                printf("OFF\n");
                break;
            case ON:
                printf("ON\n");
                break;
            case DIMMED:
                printf("DIMMED (%d%%)\n", lights[i].brightness);
                break;
        }
    }
}

// Main function
int main() {
    // Initialize the lights
    initialize_lights();

    // Turn on some lights
    turn_on_light(0);
    turn_on_light(3);
    turn_on_light(5);

    // Dim a light
    dim_light(2, 50);

    // Print the status of all lights
    print_lights_status();

    return 0;
}