//LLAMA2-13B DATASET v1.0 Category: Socket programming ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define MAX_CLIENT_CONNECTIONS 10
#define MAX_MESSAGE_LENGTH 1024

int main() {
    int sock = 0;
    struct sockaddr_in server_addr, client_addr;
    socklen_t client_len = sizeof(client_addr);
    char buffer[MAX_MESSAGE_LENGTH];
    int client_count = 0;

    // Create a socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket creation failed");
        exit(EXIT_FAILURE);
    }

    // Set up the server address
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = INADDR_ANY;
    server_addr.sin_port = htons(1234);

    // Bind the socket to the address and port
    if (bind(sock, (struct sockaddr*) &server_addr, sizeof(server_addr)) < 0) {
        perror("binding failed");
        exit(EXIT_FAILURE);
    }

    // Listen for incoming connections
    if (listen(sock, MAX_CLIENT_CONNECTIONS) < 0) {
        perror("listening failed");
        exit(EXIT_FAILURE);
    }

    printf("Server listening on port %d...\n", server_addr.sin_port);

    // Accept an incoming connection
    client_len = sizeof(client_addr);
    sock = accept(sock, (struct sockaddr*) &client_addr, &client_len);
    if (sock < 0) {
        perror("accept failed");
        exit(EXIT_FAILURE);
    }

    printf("Connection accepted from client %s:%d...\n",
           inet_ntoa(client_addr.sin_addr), ntohs(client_addr.sin_port));

    // Read data from the client
    read(sock, buffer, MAX_MESSAGE_LENGTH);
    printf("Client message: %s\n", buffer);

    // Send a response back to the client
    char* message = "Hello, client!";
    send(sock, message, strlen(message), 0);

    // Close the socket
    close(sock);

    printf("Client disconnected...\n");

    return 0;
}