//GEMINI-pro DATASET v1.0 Category: Recursive ; Style: secure
#include <stdio.h>
#include <stdlib.h>

// Function to calculate the factorial of a number
int factorial(int n) {
  if (n == 0) {
    return 1;
  } else {
    return n * factorial(n - 1);
  }
}

// Function to calculate the sum of the digits of a number
int sumOfDigits(int n) {
  if (n == 0) {
    return 0;
  } else {
    return n % 10 + sumOfDigits(n / 10);
  }
}

// Function to check if a number is prime
int isPrime(int n) {
  if (n <= 1) {
    return 0;
  } else if (n <= 3) {
    return 1;
  } else if (n % 2 == 0 || n % 3 == 0) {
    return 0;
  } else {
    int i = 5;
    while (i * i <= n) {
      if (n % i == 0 || n % (i + 2) == 0) {
        return 0;
      }
      i += 6;
    }
    return 1;
  }
}

// Function to find the greatest common divisor of two numbers
int gcd(int a, int b) {
  if (b == 0) {
    return a;
  } else {
    return gcd(b, a % b);
  }
}

// Function to find the least common multiple of two numbers
int lcm(int a, int b) {
  return a * b / gcd(a, b);
}

// Function to find the nth fibonacci number
int fibonacci(int n) {
  if (n == 0) {
    return 0;
  } else if (n == 1) {
    return 1;
  } else {
    return fibonacci(n - 1) + fibonacci(n - 2);
  }
}

// Function to find the sum of the first n natural numbers
int sumOfNaturalNumbers(int n) {
  if (n == 0) {
    return 0;
  } else {
    return n + sumOfNaturalNumbers(n - 1);
  }
}

// Function to find the sum of the first n even numbers
int sumOfEvenNumbers(int n) {
  if (n == 0) {
    return 0;
  } else {
    return 2 * n + sumOfEvenNumbers(n - 1);
  }
}

// Function to find the sum of the first n odd numbers
int sumOfOddNumbers(int n) {
  if (n == 0) {
    return 0;
  } else {
    return 2 * n - 1 + sumOfOddNumbers(n - 1);
  }
}

// Function to find the sum of the first n prime numbers
int sumOfPrimeNumbers(int n) {
  if (n == 0) {
    return 0;
  } else {
    int sum = 0;
    int i = 2;
    while (n > 0) {
      if (isPrime(i)) {
        sum += i;
        n--;
      }
      i++;
    }
    return sum;
  }
}

// Function to find the sum of the first n perfect squares
int sumOfPerfectSquares(int n) {
  if (n == 0) {
    return 0;
  } else {
    return n * n + sumOfPerfectSquares(n - 1);
  }
}

// Function to find the sum of the first n cubes
int sumOfCubes(int n) {
  if (n == 0) {
    return 0;
  } else {
    return n * n * n + sumOfCubes(n - 1);
  }
}

int main() {
  // Example usage of the functions

  // Calculate the factorial of a number
  int n = 5;
  int factorial_n = factorial(n);
  printf("The factorial of %d is %d\n", n, factorial_n);

  // Calculate the sum of the digits of a number
  n = 12345;
  int sum_of_digits = sumOfDigits(n);
  printf("The sum of the digits of %d is %d\n", n, sum_of_digits);

  // Check if a number is prime
  n = 17;
  int is_prime = isPrime(n);
  printf("%d is %sa prime number\n", n, is_prime ? "" : "not ");

  // Find the greatest common divisor of two numbers
  int a = 12;
  int b = 18;
  int gcd_ab = gcd(a, b);
  printf("The greatest common divisor of %d and %d is %d\n", a, b, gcd_ab);

  // Find the least common multiple of two numbers
  int lcm_ab = lcm(a, b);
  printf("The least common multiple of %d and %d is %d\n", a, b, lcm_ab);

  // Find the nth fibonacci number
  n = 10;
  int fibonacci_n = fibonacci(n);
  printf("The %dth fibonacci number is %d\n", n, fibonacci_n);

  // Find the sum of the first n natural numbers
  n = 10;
  int sum_of_natural_numbers = sumOfNaturalNumbers(n);
  printf("The sum of the first %d natural numbers is %d\n", n, sum_of_natural_numbers);

  // Find the sum of the first n even numbers
  n = 10;
  int sum_of_even_numbers = sumOfEvenNumbers(n);
  printf("The sum of the first %d even numbers is %d\n", n, sum_of_even_numbers);

  // Find the sum of the first n odd numbers
  n = 10;
  int sum_of_odd_numbers = sumOfOddNumbers(n);
  printf("The sum of the first %d odd numbers is %d\n", n, sum_of_odd_numbers);

  // Find the sum of the first n prime numbers
  n = 10;
  int sum_of_prime_numbers = sumOfPrimeNumbers(n);
  printf("The sum of the first %d prime numbers is %d\n", n, sum_of_prime_numbers);

  // Find the sum of the first n perfect squares
  n = 10;
  int sum_of_perfect_squares = sumOfPerfectSquares(n);
  printf("The sum of the first %d perfect squares is %d\n", n, sum_of_perfect_squares);

  // Find the sum of the first n cubes
  n = 10;
  int sum_of_cubes = sumOfCubes(n);
  printf("The sum of the first %d cubes is %d\n", n, sum_of_cubes);

  return 0;
}