//GEMINI-pro DATASET v1.0 Category: Searching algorithm ; Style: complex
#include <stdio.h>
#include <stdlib.h>

// Declare the ternary search function
int ternary_search(int *arr, int n, int target);

// Define the main function
int main() {
    // Declare the array and its size
    int arr[] = {1, 3, 5, 7, 9, 11, 13, 15, 17, 19};
    int n = sizeof(arr) / sizeof(arr[0]);

    // Declare the target value
    int target = 13;

    // Perform ternary search
    int result = ternary_search(arr, n, target);

    // Print the result
    if (result == -1) {
        printf("Target not found.\n");
    } else {
        printf("Target found at index %d.\n", result);
    }

    return 0;
}

// Define the ternary search function
int ternary_search(int *arr, int n, int target) {
    // Check if the array is empty
    if (n == 0) {
        return -1;
    }

    // Calculate the mid1 and mid2 indices
    int mid1 = n / 3;
    int mid2 = 2 * n / 3;

    // Check if the target is equal to the element at mid1
    if (arr[mid1] == target) {
        return mid1;
    }

    // Check if the target is equal to the element at mid2
    if (arr[mid2] == target) {
        return mid2;
    }

    // If the target is less than the element at mid1, search in the first third of the array
    if (target < arr[mid1]) {
        return ternary_search(arr, mid1, target);
    }

    // If the target is greater than the element at mid2, search in the last third of the array
    if (target > arr[mid2]) {
        return ternary_search(arr + mid2 + 1, n - mid2 - 1, target);
    }

    // If the target is between the elements at mid1 and mid2, search in the middle third of the array
    return ternary_search(arr + mid1 + 1, mid2 - mid1 - 1, target);
}