//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: realistic
#include <stdio.h>
#include <stdlib.h>

#define SET_BIT(var, bit) (var |= (1 << bit))
#define CLEAR_BIT(var, bit) (var &= ~(1 << bit))
#define TOGGLE_BIT(var, bit) (var ^= (1 << bit))
#define CHECK_BIT(var, bit) ((var >> bit) & 1)

int main() {
    // Declare an integer variable
    int num = 5;

    // Set the 2nd bit of the variable
    SET_BIT(num, 2);

    // Clear the 4th bit of the variable
    CLEAR_BIT(num, 4);

    // Toggle the 3rd bit of the variable
    TOGGLE_BIT(num, 3);

    // Print the binary representation of the variable
    printf("Binary representation of %d: ", num);
    for (int i = 7; i >= 0; i--) {
        printf("%d", CHECK_BIT(num, i));
    }
    printf("\n");

    // Check if the 5th bit of the variable is set
    if (CHECK_BIT(num, 5)) {
        printf("5th bit of %d is set\n", num);
    } else {
        printf("5th bit of %d is not set\n", num);
    }

    // Get the value of the 6th bit of the variable using the shift operator
    int sixth_bit = (num >> 6) & 1;
    printf("Value of the 6th bit of %d: %d\n", num, sixth_bit);

    // Perform bitwise operations on two integers
    int num1 = 10;
    int num2 = 5;

    printf("Bitwise AND of %d and %d: %d\n", num1, num2, num1 & num2);
    printf("Bitwise OR of %d and %d: %d\n", num1, num2, num1 | num2);
    printf("Bitwise XOR of %d and %d: %d\n", num1, num2, num1 ^ num2);
    printf("Bitwise complement of %d: %d\n", num1, ~num1);

    // Shift the bits of an integer
    int num3 = 20;

    printf("Shifting %d left by 2: %d\n", num3, num3 << 2);
    printf("Shifting %d right by 1: %d\n", num3, num3 >> 1);

    return 0;
}