//LLAMA2-13B DATASET v1.0 Category: Networking ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8888

int main() {
    int sock, cli_sock;
    struct sockaddr_in serv_addr, cli_addr;
    socklen_t cli_len = sizeof(cli_addr);
    char buffer[256];

    // Create the server socket
    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    // Set address and port number
    memset(&serv_addr, 0, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(PORT);

    // Bind the server socket
    if (bind(sock, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    }

    // Listen for incoming connections
    if (listen(sock, 3) < 0) {
        perror("listen failed");
        exit(EXIT_FAILURE);
    }

    printf("Server listening on port %d...\n", PORT);

    // Accept an incoming connection
    if ((cli_sock = accept(sock, (struct sockaddr *)&cli_addr, &cli_len)) < 0) {
        perror("accept failed");
        exit(EXIT_FAILURE);
    }

    // Print the client address
    printf("Client connected from address %s port %d...\n",
           inet_ntoa(cli_addr.sin_addr), ntohs(cli_addr.sin_port));

    // Send a message to the client
    strcpy(buffer, "Hello, peaceful client!");
    send(cli_sock, buffer, strlen(buffer), 0);

    // Receive a message from the client
    recv(cli_sock, buffer, 256, 0);
    printf("Client said: %s\n", buffer);

    // Close the client socket
    close(cli_sock);

    // Close the server socket
    close(sock);

    return 0;
}