//GEMINI-pro DATASET v1.0 Category: Robot movement control ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Robot movement directions
typedef enum {
    FORWARD,
    BACKWARD,
    LEFT,
    RIGHT,
    STOP
} Direction;

// Robot movement control structure
typedef struct {
    int x;
    int y;
    Direction direction;
} Robot;

// Initialize the robot
void initRobot(Robot *robot) {
    robot->x = 0;
    robot->y = 0;
    robot->direction = STOP;
}

// Move the robot forward
void moveForward(Robot *robot) {
    switch (robot->direction) {
        case FORWARD:
            robot->y++;
            break;
        case BACKWARD:
            robot->y--;
            break;
        case LEFT:
            robot->x--;
            break;
        case RIGHT:
            robot->x++;
            break;
        default:
            break;
    }
}

// Move the robot backward
void moveBackward(Robot *robot) {
    switch (robot->direction) {
        case FORWARD:
            robot->y--;
            break;
        case BACKWARD:
            robot->y++;
            break;
        case LEFT:
            robot->x++;
            break;
        case RIGHT:
            robot->x--;
            break;
        default:
            break;
    }
}

// Turn the robot left
void turnLeft(Robot *robot) {
    switch (robot->direction) {
        case FORWARD:
            robot->direction = LEFT;
            break;
        case BACKWARD:
            robot->direction = RIGHT;
            break;
        case LEFT:
            robot->direction = BACKWARD;
            break;
        case RIGHT:
            robot->direction = FORWARD;
            break;
        default:
            break;
    }
}

// Turn the robot right
void turnRight(Robot *robot) {
    switch (robot->direction) {
        case FORWARD:
            robot->direction = RIGHT;
            break;
        case BACKWARD:
            robot->direction = LEFT;
            break;
        case LEFT:
            robot->direction = FORWARD;
            break;
        case RIGHT:
            robot->direction = BACKWARD;
            break;
        default:
            break;
    }
}

// Stop the robot
void stopRobot(Robot *robot) {
    robot->direction = STOP;
}

// Print the robot's position and direction
void printRobot(Robot *robot) {
    printf("Robot position: (%d, %d)\n", robot->x, robot->y);
    switch (robot->direction) {
        case FORWARD:
            printf("Robot direction: FORWARD\n");
            break;
        case BACKWARD:
            printf("Robot direction: BACKWARD\n");
            break;
        case LEFT:
            printf("Robot direction: LEFT\n");
            break;
        case RIGHT:
            printf("Robot direction: RIGHT\n");
            break;
        default:
            printf("Robot direction: STOP\n");
            break;
    }
}

// Main function
int main() {
    // Create a robot
    Robot robot;

    // Initialize the robot
    initRobot(&robot);

    // Move the robot forward
    moveForward(&robot);

    // Turn the robot left
    turnLeft(&robot);

    // Move the robot forward
    moveForward(&robot);

    // Turn the robot right
    turnRight(&robot);

    // Move the robot backward
    moveBackward(&robot);

    // Stop the robot
    stopRobot(&robot);

    // Print the robot's position and direction
    printRobot(&robot);

    return 0;
}