//Gemma-7B DATASET v1.0 Category: Networking ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netdb.h>
#include <unistd.h>

#define SERVER_PORT 8888
#define BUFFER_SIZE 1024

int main()
{
    int sockfd, newsockfd, clientlen, n, port, sockopt, pid;
    struct sockaddr_in server_addr, client_addr;
    char buffer[BUFFER_SIZE];

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, htons(SERVER_PORT));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    // Bind the socket to a port
    server_addr.sin_port = htons(SERVER_PORT);
    server_addr.sin_family = AF_INET;
    if (bind(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0)
    {
        perror("Error binding socket");
        exit(1);
    }

    // Listen for clients
    listen(sockfd, 5);

    // Accept a client connection
    newsockfd = accept(sockfd, (struct sockaddr *)&client_addr, (int *) &clientlen);
    if (newsockfd < 0)
    {
        perror("Error accepting client connection");
        exit(1);
    }

    // Send a welcome message to the client
    n = write(newsockfd, "Welcome to the server!", 20);
    if (n < 0)
    {
        perror("Error sending message");
        exit(1);
    }

    // Receive a message from the client
    n = read(newsockfd, buffer, BUFFER_SIZE);
    if (n < 0)
    {
        perror("Error receiving message");
        exit(1);
    }

    // Print the client's message
    printf("Client: %s\n", buffer);

    // Close the client connection
    close(newsockfd);

    // Close the server socket
    close(sockfd);

    return 0;
}