//Falcon-180B DATASET v1.0 Category: Game ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROWS 3
#define COLS 3
#define NUM_SHAPES 3

enum shape {
    CIRCLE,
    SQUARE,
    TRIANGLE
};

void print_shape(enum shape shape, int row, int col) {
    switch(shape) {
        case CIRCLE:
            printf("O");
            break;
        case SQUARE:
            printf("X");
            break;
        case TRIANGLE:
            printf("^");
            break;
    }
}

void print_board(enum shape board[ROWS][COLS]) {
    for(int i=0; i<ROWS; i++) {
        for(int j=0; j<COLS; j++) {
            print_shape(board[i][j], i, j);
        }
        printf("\n");
    }
}

void randomize_board(enum shape board[ROWS][COLS]) {
    srand(time(NULL));
    for(int i=0; i<ROWS; i++) {
        for(int j=0; j<COLS; j++) {
            board[i][j] = (enum shape)(rand() % NUM_SHAPES);
        }
    }
}

int main() {
    enum shape board[ROWS][COLS];
    randomize_board(board);
    print_board(board);

    return 0;
}