//GPT-4o-mini DATASET v1.0 Category: Internet Speed Test Application ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#define MAX_SPEED 1000   // Simulated maximum speed in Mbps
#define TEST_DURATION 5  // Duration of the speed test in seconds
#define SERVER_COUNT 3   // Simulated server count

// Struct to hold server information
typedef struct {
    char name[50];
    int speed;  // Max speed in Mbps for this server
} Server;

// Function to simulate network speed test
int simulate_speed_test(Server server) {
    printf("Connecting to %s...\n", server.name);
    sleep(1);  // Simulating connection time
    printf("Testing bandwidth...\n");
    
    // Simulating varying network speed
    srand((unsigned)time(NULL) + rand());
    int actual_speed = rand() % server.speed;

    printf("Test complete. %s bandwidth: %d Mbps\n", server.name, actual_speed);
    return actual_speed;
}

// Function to display the results
void display_results(Server servers[], int speeds[]) {
    printf("\nSpeed Test Results:\n");
    printf("====================\n");
    for (int i = 0; i < SERVER_COUNT; i++) {
        printf("Server: %s | Speed: %d Mbps\n", servers[i].name, speeds[i]);
    }
}

int main() {
    // Array of servers
    Server servers[SERVER_COUNT] = {
        {"Redoubt-1 - The Last Bunker", MAX_SPEED},
        {"Sanctuary Server - Remnants of the Past", MAX_SPEED / 2},
        {"CommStation 42 - Wasteland Connectivity", MAX_SPEED / 3}
    };

    // Array to hold the speed results
    int speeds[SERVER_COUNT];

    printf("=========================================\n");
    printf("Wasteland Internet Speed Test\n");
    printf("For survivors only...\n");
    printf("=========================================\n");

    // Testing each server
    for (int i = 0; i < SERVER_COUNT; i++) {
        speeds[i] = simulate_speed_test(servers[i]);
        sleep(TEST_DURATION); // Simulate time between tests
    }

    // Displaying the results
    display_results(servers, speeds);
    
    printf("\nLet not the signal fade...\n");
    return 0;
}