//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LEN 100
#define MAX_FILE_SIZE 1000

typedef struct {
    char name[MAX_FILE_NAME_LEN];
    int size;
    char data[MAX_FILE_SIZE];
} File;

int numFiles = 0;
File files[MAX_FILES];

void createFile(char* name, int size) {
    if (numFiles >= MAX_FILES) {
        printf("Error: Too many files.\n");
        return;
    }

    strcpy(files[numFiles].name, name);
    files[numFiles].size = size;
    memset(files[numFiles].data, 0, MAX_FILE_SIZE);

    numFiles++;
}

void deleteFile(char* name) {
    int i;

    for (i = 0; i < numFiles; i++) {
        if (strcmp(files[i].name, name) == 0) {
            memset(files[i].data, 0, MAX_FILE_SIZE);
            strcpy(files[i].name, "");
            files[i].size = 0;

            return;
        }
    }

    printf("Error: File not found.\n");
}

void writeFile(char* name, char* data, int size) {
    int i;

    for (i = 0; i < numFiles; i++) {
        if (strcmp(files[i].name, name) == 0) {
            if (size > files[i].size) {
                printf("Error: File too large.\n");
                return;
            }

            memcpy(files[i].data, data, size);

            return;
        }
    }

    printf("Error: File not found.\n");
}

void readFile(char* name, char* buffer, int size) {
    int i;

    for (i = 0; i < numFiles; i++) {
        if (strcmp(files[i].name, name) == 0) {
            if (size > files[i].size) {
                printf("Error: File too large.\n");
                return;
            }

            memcpy(buffer, files[i].data, size);

            return;
        }
    }

    printf("Error: File not found.\n");
}

int main() {
    createFile("test.txt", 10);
    writeFile("test.txt", "Hello, world!", 13);
    readFile("test.txt", "buffer", 13);
    printf("%s\n", "buffer");

    return 0;
}