//Falcon-180B DATASET v1.0 Category: Temperature Converter ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <math.h>

#define NUM_THREADS 5
#define TRUE 1
#define FALSE 0

float temperature_celsius;
float temperature_fahrenheit;

pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

void *celsius_to_fahrenheit(void *arg) {
    int id = *((int *) arg);
    float temperature = temperature_celsius;
    float converted_temp;

    printf("Thread %d is converting Celsius to Fahrenheit\n", id);
    converted_temp = (temperature * 9/5) + 32;
    printf("Thread %d: %f degrees Celsius is %f degrees Fahrenheit\n", id, temperature_celsius, converted_temp);

    pthread_mutex_lock(&mutex);
    temperature_fahrenheit = converted_temp;
    pthread_mutex_unlock(&mutex);

    return NULL;
}

void *fahrenheit_to_celsius(void *arg) {
    int id = *((int *) arg);
    float temperature = temperature_fahrenheit;
    float converted_temp;

    printf("Thread %d is converting Fahrenheit to Celsius\n", id);
    converted_temp = (temperature - 32) * 5/9;
    printf("Thread %d: %f degrees Fahrenheit is %f degrees Celsius\n", id, temperature_fahrenheit, converted_temp);

    pthread_mutex_lock(&mutex);
    temperature_celsius = converted_temp;
    pthread_mutex_unlock(&mutex);

    return NULL;
}

int main() {
    pthread_t threads[NUM_THREADS];
    int rc;
    int i;

    temperature_celsius = 20;
    temperature_fahrenheit = 68;

    printf("Temperature in Celsius: %f\n", temperature_celsius);
    printf("Temperature in Fahrenheit: %f\n", temperature_fahrenheit);

    for (i = 0; i < NUM_THREADS; i++) {
        rc = pthread_create(&threads[i], NULL, celsius_to_fahrenheit, (void *)&i);
        if (rc) {
            printf("Error: unable to create thread, %d\n", rc);
            exit(-1);
        }
    }

    for (i = 0; i < NUM_THREADS; i++) {
        rc = pthread_join(threads[i], NULL);
        if (rc) {
            printf("Error: unable to join thread, %d\n", rc);
            exit(-1);
        }
    }

    return 0;
}