//GPT-4o-mini DATASET v1.0 Category: Greedy Algorithms ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>

typedef struct {
    int id;             // Unique item identifier
    double weight;     // Weight of the item
    double value;      // Value of the item
    double ratio;      // Value-to-weight ratio for greedy choice
} Item;

// Comparison function for sorting items based on their value-to-weight ratio
int compare(const void *a, const void *b) {
    Item *itemA = (Item *)a;
    Item *itemB = (Item *)b;
    if (itemB->ratio < itemA->ratio) return -1; // For descending order
    if (itemB->ratio > itemA->ratio) return 1;  // For descending order
    return 0;                                    // Equivalent ratios
}

// Function to compute the maximum value for the given capacity
double fractionalKnapsack(Item items[], int n, double capacity) {
    // Initializing total value to store the maximum value
    double totalValue = 0.0;

    for (int i = 0; i < n; i++) {
        // If the item can be completely accommodated
        if (items[i].weight <= capacity) {
            capacity -= items[i].weight;         // Deduct its weight from capacity
            totalValue += items[i].value;        // Add value to total value
            printf("Picked whole Item %d (Weight: %.2f, Value: %.2f)\n", items[i].id, items[i].weight, items[i].value);
        } else {
            // If the item cannot be completely accommodated, take the fraction
            double fraction = capacity / items[i].weight; // Fraction of the item we can take
            totalValue += items[i].value * fraction;     // Add fractional value to total
            printf("Picked %.2f part of Item %d (Weight: %.2f, Value: %.2f)\n", fraction, items[i].id, items[i].weight, items[i].value * fraction);
            break; // Knapsack is full, exit the loop
        }
    }

    return totalValue; // Return the maximum value we could obtain
}

int main() {
    // The mystical land of greedy solutions
    printf("Welcome to the Kingdom of Greed!\n");
    printf("In this kingdom, we shall fill the knapsack with treasures!\n");

    // List of treasures (items) to quell the hunger for value
    Item items[] = {
        {1, 10, 60, 0}, // id, weight, value
        {2, 20, 100, 0},
        {3, 30, 120, 0}
    };

    int n = sizeof(items) / sizeof(items[0]); // Number of items in the kingdom
    double capacity = 50; // The magical weight capacity of the knapsack

    // Calculate the ratio for each item and add it to the treasure map
    for (int i = 0; i < n; i++) {
        items[i].ratio = items[i].value / items[i].weight; // Value-to-weight ratio
    }

    // The call to adventure: Sorting the items based on their ratios
    qsort(items, n, sizeof(Item), compare);

    // The quest to fill the knapsack begins!
    printf("The highest potential treasures have been sorted!\n");
    printf("Our knapsack has a capacity of %.2f pounds!\n", capacity);

    // The ultimate quest begins
    double maxValue = fractionalKnapsack(items, n, capacity);

    // The realization of value
    printf("The total value we accrued is: %.2f\n", maxValue);
    printf("The kingdom's treasures have found their place!\n");

    return 0; // End of the greedy quest
}