//GEMINI-pro DATASET v1.0 Category: Benchmarking ; Style: recursive
#include <stdio.h>
#include <stdlib.h>

// Recursive function to calculate the nth Fibonacci number
int fibonacci(int n) {
  if (n <= 1) {
    return n;
  } else {
    return fibonacci(n - 1) + fibonacci(n - 2);
  }
}

// Recursive function to find the maximum element in an array
int max_element(int arr[], int n) {
  if (n == 1) {
    return arr[0];
  } else {
    int max = max_element(arr, n - 1);
    if (arr[n - 1] > max) {
      return arr[n - 1];
    } else {
      return max;
    }
  }
}

// Recursive function to calculate the factorial of a number
int factorial(int n) {
  if (n == 0) {
    return 1;
  } else {
    return n * factorial(n - 1);
  }
}

// Recursive function to calculate the sum of the digits of a number
int sum_of_digits(int n) {
  if (n == 0) {
    return 0;
  } else {
    return n % 10 + sum_of_digits(n / 10);
  }
}

// Recursive function to reverse a string
char* reverse_string(char* str) {
  if (*str == '\0') {
    return str;
  } else {
    char* temp = reverse_string(str + 1);
    *str = temp[0];
    *temp = '\0';
    return temp - 1;
  }
}

int main() {
  // Print the first 10 Fibonacci numbers
  printf("First 10 Fibonacci numbers:\n");
  for (int i = 0; i < 10; i++) {
    printf("%d ", fibonacci(i));
  }
  printf("\n");

  // Find the maximum element in an array
  int arr[] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
  int n = sizeof(arr) / sizeof(arr[0]);
  printf("Maximum element in array: %d\n", max_element(arr, n));

  // Calculate the factorial of a number
  int num = 5;
  printf("Factorial of %d: %d\n", num, factorial(num));

  // Calculate the sum of the digits of a number
  num = 12345;
  printf("Sum of the digits of %d: %d\n", num, sum_of_digits(num));

  // Reverse a string
  char str[] = "Hello";
  printf("Original string: %s\n", str);
  printf("Reversed string: %s\n", reverse_string(str));

  return 0;
}