//GPT-4o-mini DATASET v1.0 Category: Threading Library Implementation ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <string.h>
#include <unistd.h>

#define MAX_THREADS 5
#define BUFFER_SIZE 256

// Structure to hold data for each thread
typedef struct {
    int thread_id;
    char message[BUFFER_SIZE];
} thread_data_t;

// Thread function to simulate work
void* thread_function(void* arg) {
    thread_data_t* data = (thread_data_t*)arg;
    printf("Thread %d: Starting with message '%s'\n", data->thread_id, data->message);
    
    // Simulate some work with sleep
    sleep(rand() % 3 + 1);

    printf("Thread %d: Finished processing\n", data->thread_id);
    pthread_exit(NULL);
}

int main() {
    pthread_t threads[MAX_THREADS];
    thread_data_t thread_data[MAX_THREADS];
    int rc;
    int i;

    // Seed random number generator
    srand(time(NULL));

    // Create threads
    for (i = 0; i < MAX_THREADS; i++) {
        snprintf(thread_data[i].message, sizeof(thread_data[i].message), "Hello from thread %d", i);
        thread_data[i].thread_id = i;

        rc = pthread_create(&threads[i], NULL, thread_function, (void*)&thread_data[i]);
        if (rc) {
            fprintf(stderr, "Error: Unable to create thread %d, %d\n", i, rc);
            exit(EXIT_FAILURE);
        }
    }

    // Wait for all threads to complete
    for (i = 0; i < MAX_THREADS; i++) {
        rc = pthread_join(threads[i], NULL);
        if (rc) {
            fprintf(stderr, "Error: Unable to join thread %d, %d\n", i, rc);
            exit(EXIT_FAILURE);
        }
    }

    printf("All threads completed successfully!\n");
    exit(EXIT_SUCCESS);
}