//GPT-4o-mini DATASET v1.0 Category: Subnet Calculator ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>

#define MAX_SUBNETS 256

void calculate_subnet(const char *ip_str, const char *mask_str);
void print_subnet_info(struct in_addr subnet, struct in_addr broadcast, struct in_addr netmask, int total_hosts);
unsigned long calculate_total_hosts(int bits);
void validate_ip(const char *ip_str);
void validate_mask(const char *mask_str);

int main() {
    char ip[16];
    char mask[16];

    printf("Welcome to the C Subnet Calculator!\n");
    printf("Enter an IP address (e.g., 192.168.1.1): ");
    scanf("%15s", ip);
    validate_ip(ip);
    
    printf("Enter a netmask (e.g., 255.255.255.0): ");
    scanf("%15s", mask);
    validate_mask(mask);

    calculate_subnet(ip, mask);

    return 0;
}

void calculate_subnet(const char *ip_str, const char *mask_str) {
    struct in_addr ip, mask, subnet, broadcast;
    int total_hosts, subnet_bits;

    if (inet_pton(AF_INET, ip_str, &ip) != 1) {
        fprintf(stderr, "Invalid IP address format.\n");
        exit(EXIT_FAILURE);
    }

    if (inet_pton(AF_INET, mask_str, &mask) != 1) {
        fprintf(stderr, "Invalid subnet mask format.\n");
        exit(EXIT_FAILURE);
    }

    // Calculate subnet by performing bitwise AND between IP and mask
    subnet.s_addr = ip.s_addr & mask.s_addr;
    
    // Calculate broadcast address by performing bitwise OR between subnet and inverse of mask
    broadcast.s_addr = subnet.s_addr | ~mask.s_addr;

    // Calculate number of hosts
    subnet_bits = __builtin_popcount(mask.s_addr);
    total_hosts = calculate_total_hosts(32 - subnet_bits);

    // Print the results
    print_subnet_info(subnet, broadcast, mask, total_hosts);
}

void print_subnet_info(struct in_addr subnet, struct in_addr broadcast, struct in_addr netmask, int total_hosts) {
    char subnet_str[INET_ADDRSTRLEN];
    char broadcast_str[INET_ADDRSTRLEN];
    char netmask_str[INET_ADDRSTRLEN];

    inet_ntop(AF_INET, &subnet, subnet_str, sizeof(subnet_str));
    inet_ntop(AF_INET, &broadcast, broadcast_str, sizeof(broadcast_str));
    inet_ntop(AF_INET, &netmask, netmask_str, sizeof(netmask_str));

    printf("\nSubnet Information:\n");
    printf("Subnet Address: %s\n", subnet_str);
    printf("Broadcast Address: %s\n", broadcast_str);
    printf("Netmask: %s\n", netmask_str);
    printf("Total Usable Hosts: %d\n", total_hosts);
}

unsigned long calculate_total_hosts(int bits) {
    // total usable hosts = 2^bits - 2 (for network and broadcast addresses)
    return (1UL << bits) - 2;
}

void validate_ip(const char *ip_str) {
    struct sockaddr_in sa;
    int result = inet_pton(AF_INET, ip_str, &(sa.sin_addr));
    if (result == 0) {
        fprintf(stderr, "Invalid IP address. Please provide a correct IPv4 format.\n");
        exit(EXIT_FAILURE);
    }
}

void validate_mask(const char *mask_str) {
    struct sockaddr_in sa;
    int result = inet_pton(AF_INET, mask_str, &(sa.sin_addr));
    if (result == 0) {
        fprintf(stderr, "Invalid subnet mask. Please provide a correct IPv4 format.\n");
        exit(EXIT_FAILURE);
    }
}