//Falcon2-11B DATASET v1.0 Category: Socket programming ; Style: unmistakable
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
    // Create a socket
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("socket");
        return 1;
    }

    // Create a server socket
    struct sockaddr_in server;
    memset(&server, 0, sizeof(server));
    server.sin_family = AF_INET;
    server.sin_port = htons(8080);
    server.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Bind the socket to the server address
    if (bind(sockfd, (struct sockaddr*)&server, sizeof(server)) < 0) {
        perror("bind");
        return 1;
    }

    // Listen for incoming connections
    int backlog = 5;
    if (listen(sockfd, backlog) < 0) {
        perror("listen");
        return 1;
    }

    printf("Listening on port 8080...\n");

    // Accept a connection
    int clientfd;
    struct sockaddr_in client;
    socklen_t clientlen = sizeof(client);
    clientfd = accept(sockfd, (struct sockaddr*)&client, &clientlen);
    if (clientfd < 0) {
        perror("accept");
        return 1;
    }

    // Receive data from the client
    char buffer[1024];
    int bytes_received = recv(clientfd, buffer, sizeof(buffer), 0);
    if (bytes_received < 0) {
        perror("recv");
        return 1;
    }

    // Print the received data
    printf("Received data: %s\n", buffer);

    // Close the connection
    close(clientfd);

    return 0;
}