//Falcon2-11B DATASET v1.0 Category: Breakout Game Clone ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <GL/glut.h>

#define WIDTH 800
#define HEIGHT 600

#define BALL_RADIUS 10
#define PADDLE_WIDTH 50
#define PADDLE_HEIGHT 100
#define BALL_SPEED 5

GLint ball_x, ball_y;
GLint paddle_x, paddle_y;
GLint paddle_speed;

void init()
{
    glClearColor(0.5, 0.5, 0.5, 0.0); // Set background color to gray
    glShadeModel(GL_SMOOTH); // Enable smooth shading
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity(); // Reset projection matrix
    gluOrtho2D(0.0, WIDTH, HEIGHT, 0.0); // Set orthographic projection
    glMatrixMode(GL_MODELVIEW);
}

void display()
{
    glClear(GL_COLOR_BUFFER_BIT); // Clear the screen

    glColor3f(1.0, 1.0, 1.0); // Set ball color
    glBegin(GL_POLYGON); // Begin drawing a polygon
    // Draw ball
    glVertex2f(ball_x - BALL_RADIUS, ball_y - BALL_RADIUS);
    glVertex2f(ball_x - BALL_RADIUS, ball_y + BALL_RADIUS);
    glVertex2f(ball_x + BALL_RADIUS, ball_y + BALL_RADIUS);
    glVertex2f(ball_x + BALL_RADIUS, ball_y - BALL_RADIUS);
    glEnd(); // End drawing the polygon

    glColor3f(0.0, 0.0, 1.0); // Set paddle color
    glBegin(GL_POLYGON); // Begin drawing a polygon
    // Draw paddle
    glVertex2f(paddle_x, paddle_y + PADDLE_HEIGHT);
    glVertex2f(paddle_x + PADDLE_WIDTH, paddle_y + PADDLE_HEIGHT);
    glVertex2f(paddle_x + PADDLE_WIDTH, paddle_y);
    glVertex2f(paddle_x, paddle_y);
    glEnd(); // End drawing the polygon

    glColor3f(1.0, 1.0, 1.0); // Set ball color
    glBegin(GL_POLYGON); // Begin drawing a polygon
    // Draw paddle
    glVertex2f(paddle_x, paddle_y);
    glVertex2f(paddle_x + PADDLE_WIDTH, paddle_y);
    glVertex2f(paddle_x + PADDLE_WIDTH, paddle_y + PADDLE_HEIGHT);
    glVertex2f(paddle_x, paddle_y + PADDLE_HEIGHT);
    glEnd(); // End drawing the polygon

    glFlush(); // Make the changes to the screen
}

void keyboard(unsigned char key, int x, int y)
{
    switch (key)
    {
        case 'p': // Pause the game
            paddle_speed = 0;
            break;
        case 'r': // Reset the game
            ball_x = WIDTH / 2 - BALL_RADIUS;
            ball_y = HEIGHT / 2 - BALL_RADIUS;
            paddle_x = WIDTH / 2 - PADDLE_WIDTH / 2;
            paddle_y = HEIGHT / 2 - PADDLE_HEIGHT;
            paddle_speed = 5;
            break;
    }
}

void mouse(int button, int state, int x, int y)
{
    if (button == GLUT_LEFT_BUTTON && state == GLUT_DOWN)
    {
        if (paddle_x > 0 && ball_x < WIDTH / 2)
        {
            paddle_x -= 10;
        }
        else if (paddle_x < WIDTH - PADDLE_WIDTH && ball_x > WIDTH / 2)
        {
            paddle_x += 10;
        }
    }
}

void idle()
{
    if (ball_y < 0 || ball_y > HEIGHT)
    {
        ball_y = HEIGHT / 2 - BALL_RADIUS;
        ball_x = WIDTH / 2 - BALL_RADIUS;
    }

    if (ball_x < 0)
    {
        ball_x = 0;
    }
    else if (ball_x > WIDTH)
    {
        ball_x = WIDTH;
    }

    ball_x += BALL_SPEED;
    ball_y += BALL_SPEED;

    if (paddle_y < 0 || paddle_y > HEIGHT)
    {
        paddle_y = HEIGHT / 2 - PADDLE_HEIGHT;
    }

    if (paddle_x < 0)
    {
        paddle_x = 0;
    }
    else if (paddle_x > WIDTH)
    {
        paddle_x = WIDTH;
    }

    paddle_x += paddle_speed;
}

int main(int argc, char** argv)
{
    int width, height;
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
    glutInitWindowSize(WIDTH, HEIGHT);
    glutCreateWindow("Breakout Game Clone");
    init();
    glutDisplayFunc(display);
    glutKeyboardFunc(keyboard);
    glutMouseFunc(mouse);
    glutIdleFunc(idle);
    glutMainLoop();
    return 0;
}