//GPT-4o-mini DATASET v1.0 Category: Bitwise operations ; Style: authentic
#include <stdio.h>

// Function to display the binary representation of a number
void printBinary(int num) {
    for (int i = sizeof(num) * 8 - 1; i >= 0; i--) {
        int bit = (num >> i) & 1;
        printf("%d", bit);
    }
    printf("\n");
}

// Function to perform and display various bitwise operations
void bitwiseOperations(int a, int b) {
    printf("Bitwise Operations between %d and %d:\n", a, b);
    
    // Bitwise AND
    int andResult = a & b;
    printf("AND:            ");
    printBinary(a);
    printf("AND:            ");
    printBinary(b);
    printf("Result of AND: ");
    printBinary(andResult);
    printf("Decimal Result: %d\n\n", andResult);

    // Bitwise OR
    int orResult = a | b;
    printf("OR:             ");
    printBinary(a);
    printf("OR:             ");
    printBinary(b);
    printf("Result of OR:  ");
    printBinary(orResult);
    printf("Decimal Result: %d\n\n", orResult);

    // Bitwise XOR
    int xorResult = a ^ b;
    printf("XOR:            ");
    printBinary(a);
    printf("XOR:            ");
    printBinary(b);
    printf("Result of XOR:  ");
    printBinary(xorResult);
    printf("Decimal Result: %d\n\n", xorResult);

    // Bitwise NOT
    int notA = ~a;
    printf("NOT A:          ");
    printBinary(a);
    printf("Result of NOT A:");
    printBinary(notA);
    printf("Decimal Result: %d\n\n", notA);

    int notB = ~b;
    printf("NOT B:          ");
    printBinary(b);
    printf("Result of NOT B:");
    printBinary(notB);
    printf("Decimal Result: %d\n\n", notB);
}

// Function to rotate bits left
unsigned int rotateLeft(unsigned int value, int positions) {
    return (value << positions) | (value >> (32 - positions));
}

// Function to rotate bits right
unsigned int rotateRight(unsigned int value, int positions) {
    return (value >> positions) | (value << (32 - positions));
}

// Function to demonstrate rotations
void demonstrateRotations(int num) {
    printf("Number: ");
    printBinary(num);
    
    for(int i = 1; i <= 3; i++) {
        unsigned int leftRotated = rotateLeft(num, i);
        unsigned int rightRotated = rotateRight(num, i);

        printf("\nRotating %d bit(s):\n", i);
        printf("Left Rotation:  ");
        printBinary(leftRotated);
        printf("Decimal Result: %u\n", leftRotated);
        
        printf("Right Rotation: ");
        printBinary(rightRotated);
        printf("Decimal Result: %u\n", rightRotated);
    }
}

int main() {
    int a = 14; // Example value
    int b = 7;  // Example value
    
    // Display bitwise operations
    bitwiseOperations(a, b);

    // Demonstrate rotations
    printf("Demonstrating rotations on the number %d:\n", a);
    demonstrateRotations(a);

    return 0;
}