//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOSTS 5

typedef struct Ghost {
    char name[20];
    int room_num;
    int movement_type;
    int current_location;
} Ghost;

Ghost ghosts[MAX_GHOSTS] = {
    {"Mary", 1, 1, 1},
    {"John", 2, 2, 2},
    {"Alice", 3, 3, 3},
    {"Bob", 4, 4, 4},
    {"Tom", 5, 5, 5}
};

int main() {
    int i, j, r, n, ghosts_num = 0;

    printf("Welcome to the Haunted House Simulator!\n");

    // Generate a random number of ghosts
    n = rand() % MAX_GHOSTS + 1;
    ghosts_num = n;

    // Create the haunted house
    for (i = 0; i < n; i++) {
        ghosts[i].current_location = rand() % 5 + 1;
    }

    // Move the ghosts
    for (i = 0; i < ghosts_num; i++) {
        switch (ghosts[i].movement_type) {
            case 1:
                ghosts[i].current_location = (ghosts[i].current_location + 1) % 5 + 1;
                break;
            case 2:
                ghosts[i].current_location = (ghosts[i].current_location - 1) % 5 + 1;
                break;
            case 3:
                ghosts[i].current_location = rand() % 5 + 1;
                break;
        }
    }

    // Print the haunted house
    for (i = 0; i < n; i++) {
        printf("Ghost %s is in room %d.\n", ghosts[i].name, ghosts[i].current_location);
    }

    return 0;
}