//Falcon-180B DATASET v1.0 Category: Memory Game ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROWS 4
#define COLS 4

void initBoard(char board[ROWS][COLS]) {
    int i, j;
    for (i = 0; i < ROWS; i++) {
        for (j = 0; j < COLS; j++) {
            board[i][j] = '-';
        }
    }
}

void printBoard(char board[ROWS][COLS]) {
    int i, j;
    for (i = 0; i < ROWS; i++) {
        for (j = 0; j < COLS; j++) {
            printf("%c ", board[i][j]);
        }
        printf("\n");
    }
}

void placeCard(char board[ROWS][COLS], int row, int col) {
    int value;
    char suit;

    srand(time(NULL));
    value = rand() % 13 + 1;

    switch (value) {
        case 1:
            suit = 'A';
            break;
        case 11:
            suit = 'J';
            break;
        case 12:
            suit = 'Q';
            break;
        case 13:
            suit = 'K';
            break;
        default:
            suit = '0' + value;
            break;
    }

    board[row][col] = suit;
}

int checkMatch(char board[ROWS][COLS], int row, int col) {
    if (board[row][col] == '-')
        return 0;

    int value = board[row][col] - '0';
    char suit = board[row][col];

    if (value == 1 || value == 11 || value == 12 || value == 13) {
        return 1;
    }

    int i, j;
    for (i = 0; i < ROWS; i++) {
        for (j = 0; j < COLS; j++) {
            if (i!= row && j!= col && board[i][j]!= '-' && board[i][j] == suit) {
                return 1;
            }
        }
    }

    return 0;
}

int main() {
    char board[ROWS][COLS];
    int matches = 0;

    initBoard(board);

    int i, j;
    for (i = 0; i < ROWS * COLS; i++) {
        int row = i / COLS;
        int col = i % COLS;

        placeCard(board, row, col);

        if (checkMatch(board, row, col)) {
            matches++;
        }
    }

    printf("Total matches: %d\n", matches);

    return 0;
}