//Gemma-7B DATASET v1.0 Category: Classical Circuit Simulator ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CIRcuits 10

typedef struct Circuit {
    char name[20];
    int numComponents;
    double resistance;
    double capacitance;
    double inductance;
} Circuit;

Circuit circuits[MAX_CIRcuits];

void createCircuit(char *name, int numComponents, double resistance, double capacitance, double inductance) {
    int i = 0;
    for (; i < MAX_CIRcuits && circuits[i].name[0] != '\0'; i++) {}

    circuits[i].name[0] = '\0';
    strcpy(circuits[i].name, name);
    circuits[i].numComponents = numComponents;
    circuits[i].resistance = resistance;
    circuits[i].capacitance = capacitance;
    circuits[i].inductance = inductance;
}

void simulateCircuit(char *circuitName) {
    int i = 0;
    for (; i < MAX_CIRcuits && circuits[i].name[0] != '\0'; i++) {
        if (strcmp(circuits[i].name, circuitName) == 0) {
            printf("Circuit Name: %s\n", circuits[i].name);
            printf("Number of Components: %d\n", circuits[i].numComponents);
            printf("Resistance: %.2f ohms\n", circuits[i].resistance);
            printf("Capacitance: %.2f farads\n", circuits[i].capacitance);
            printf("Inductance: %.2f henrys\n", circuits[i].inductance);
            break;
        }
    }

    if (i == MAX_CIRcuits) {
        printf("Circuit not found.\n");
    }
}

int main() {
    createCircuit("My Circuit", 5, 10.0, 2.0, 0.5);
    simulateCircuit("My Circuit");

    return 0;
}