//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>

#define MAX_PROCESSES 10

typedef struct Process {
    int process_id;
    char name[20];
    int cpu_burst_time;
    int waiting_time;
    int turnaround_time;
} Process;

void calculate_cpu_burst_time(Process *process) {
    process->waiting_time = 0;
    process->turnaround_time = process->cpu_burst_time;
}

void simulate_process_execution(Process *process) {
    sleep(process->cpu_burst_time);
    process->waiting_time++;
}

void calculate_turnaround_time(Process *process) {
    process->turnaround_time = process->waiting_time + process->cpu_burst_time;
}

int main() {
    Process processes[MAX_PROCESSES];
    int i;

    for (i = 0; i < MAX_PROCESSES; i++) {
        processes[i].process_id = i + 1;
        processes[i].name[0] = 'A' + i;
        processes[i].cpu_burst_time = rand() % 5 + 1;
    }

    for (i = 0; i < MAX_PROCESSES; i++) {
        calculate_cpu_burst_time(&processes[i]);
    }

    for (i = 0; i < MAX_PROCESSES; i++) {
        simulate_process_execution(&processes[i]);
    }

    for (i = 0; i < MAX_PROCESSES; i++) {
        calculate_turnaround_time(&processes[i]);
    }

    for (i = 0; i < MAX_PROCESSES; i++) {
        printf("Process ID: %d, Name: %s, CPU Burst Time: %d, Waiting Time: %d, Turnaround Time: %d\n", processes[i].process_id, processes[i].name, processes[i].cpu_burst_time, processes[i].waiting_time, processes[i].turnaround_time);
    }

    return 0;
}