//GPT-4o-mini DATASET v1.0 Category: Dice Roller ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_DICE 5
#define ROLLS 3

void printInstructions() {
    printf("Welcome to the Dice Roller!\n");
    printf("You can roll up to %d dice at once and you will have %d rolls to get your best outcome.\n", NUM_DICE, ROLLS);
    printf("Let's see how lucky you are!\n\n");
}

void rollDice(int dices[], int count) {
    for(int i = 0; i < count; i++) {
        dices[i] = (rand() % 6) + 1; // Roll a die (1-6)
    }
}

void printDice(int dices[], int count) {
    printf("You rolled: ");
    for(int i = 0; i < count; i++) {
        printf("%d ", dices[i]);
    }
    printf("\n");
}

int calculateScore(int dices[], int count) {
    int score = 0;
    for(int i = 0; i < count; i++) {
        score += dices[i];
    }
    return score;
}

void playGame() {
    int dices[NUM_DICE];
    int highestScore = 0;
    int bestRolls[NUM_DICE];

    for(int roll = 1; roll <= ROLLS; roll++) {
        printf("Roll %d:\n", roll);
        rollDice(dices, NUM_DICE);
        printDice(dices, NUM_DICE);
        
        int score = calculateScore(dices, NUM_DICE);
        printf("Total Score: %d\n\n", score);
        
        if(score > highestScore) {
            highestScore = score;
            for(int i = 0; i < NUM_DICE; i++) {
                bestRolls[i] = dices[i];
            }
        }
    }

    printf("Your best roll was: ");
    printDice(bestRolls, NUM_DICE);
    printf("With a score of: %d\n", highestScore);
}

int main() {
    srand(time(0)); // Seed the random number generator
    printInstructions();
    playGame();
    
    printf("Thanks for playing the Dice Roller! Goodbye!\n");
    return 0;
}