//GPT-4o-mini DATASET v1.0 Category: System event logger ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>

#define LOG_FILE "event_log.txt"

// Function to get the current timestamp
const char* current_timestamp() {
    static char buffer[20];
    time_t now = time(NULL);
    struct tm *tm_info = localtime(&now);
    strftime(buffer, sizeof(buffer), "%Y-%m-%d %H:%M:%S", tm_info);
    return buffer;
}

// Function to log events to a file
void log_event(const char *event) {
    FILE *file = fopen(LOG_FILE, "a");
    if (file == NULL) {
        perror("Could not open log file");
        return;
    }
    fprintf(file, "[%s] %s\n", current_timestamp(), event);
    fclose(file);
}

// Function to log system startup
void log_system_startup() {
    const char *event = "🎉 Surprise! The system has started! 🎉";
    log_event(event);
    printf("%s\n", event);
}

// Function to log user action
void log_user_action(const char *action) {
    char event[100];
    snprintf(event, sizeof(event), "User performed action: %s", action);
    log_event(event);
    printf("%s\n", event);
}

// Function to log errors
void log_error(const char *error) {
    char event[100];
    snprintf(event, sizeof(event), "⚠️ Oh no! An error occurred: %s ⚠️", error);
    log_event(event);
    printf("%s\n", event);
}

// Main function to simulate system events
int main() {
    // Log system startup
    log_system_startup();

    // Simulate some user actions
    sleep(1);
    log_user_action("User logged in");

    sleep(2);
    log_user_action("User opened the settings menu");

    sleep(1);
    log_user_action("User changed their profile picture");

    // Simulate an error
    sleep(1);
    log_error("Profile picture format not supported");

    sleep(2);
    log_user_action("User logged out");

    // End of the program; log shutdown
    const char *event = "🎉 Surprise! The system is shutting down gracefully. 🎉";
    log_event(event);
    printf("%s\n", event);

    return 0;
}