//Falcon-180B DATASET v1.0 Category: Building a SMTP Client ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <errno.h>

#define BUFFER_SIZE 1024

int main(int argc, char **argv) {
    int sockfd, n;
    struct sockaddr_in serveraddr;
    char buffer[BUFFER_SIZE];

    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    // Set server address
    memset(&serveraddr, 0, sizeof(serveraddr));
    serveraddr.sin_family = AF_INET;
    serveraddr.sin_addr.s_addr = inet_addr("smtp.gmail.com");
    serveraddr.sin_port = htons(587);

    // Connect to server
    if (connect(sockfd, (struct sockaddr *)&serveraddr, sizeof(serveraddr)) == -1) {
        perror("connect failed");
        exit(EXIT_FAILURE);
    }

    // Send HELO command
    send(sockfd, "HELO localhost\r\n", strlen("HELO localhost\r\n"), 0);

    // Send MAIL FROM command
    send(sockfd, "MAIL FROM: <sender@example.com>\r\n", strlen("MAIL FROM: <sender@example.com>\r\n"), 0);

    // Send RCPT TO command
    send(sockfd, "RCPT TO: <recipient@example.com>\r\n", strlen("RCPT TO: <recipient@example.com>\r\n"), 0);

    // Send DATA command
    send(sockfd, "DATA\r\n", strlen("DATA\r\n"), 0);

    // Send message body
    char message[] = "Subject: Test Message\r\n\r\nHello, World!\r\n";
    send(sockfd, message, strlen(message), 0);

    // Close connection
    close(sockfd);

    return 0;
}