//GEMINI-pro DATASET v1.0 Category: System boot optimizer ; Style: artistic
#include <stdlib.h>
#include <stdio.h>

// Macro to get the size of an array
#define ARRAY_SIZE(oc) (sizeof(oc) / sizeof(oc[0]))

// Function to find the minimum element in an array
int find_min(int arr[], int n) {
  int min = arr[0];
  for (int i = 1; i < n; i++) {
    if (arr[i] < min) {
      min = arr[i];
    }
  }
  return min;
}

// Function to find the maximum element in an array
int find_max(int arr[], int n) {
  int max = arr[0];
  for (int i = 1; i < n; i++) {
    if (arr[i] > max) {
      max = arr[i];
    }
  }
  return max;
}

// Function to find the average of an array
double find_avg(int arr[], int n) {
  double sum = 0;
  for (int i = 0; i < n; i++) {
    sum += arr[i];
  }
  return sum / n;
}

// Function to sort an array in ascending order
void sort_ascending(int arr[], int n) {
  for (int i = 0; i < n - 1; i++) {
    for (int j = i + 1; j < n; j++) {
      if (arr[i] > arr[j]) {
        int temp = arr[i];
        arr[i] = arr[j];
        arr[j] = temp;
      }
    }
  }
}

// Function to sort an array in descending order
void sort_descending(int arr[], int n) {
  for (int i = 0; i < n - 1; i++) {
    for (int j = i + 1; j < n; j++) {
      if (arr[i] < arr[j]) {
        int temp = arr[i];
        arr[i] = arr[j];
        arr[j] = temp;
      }
    }
  }
}

// Function to print an array
void print_array(int arr[], int n) {
  for (int i = 0; i < n; i++) {
    printf("%d ", arr[i]);
  }
  printf("\n");
}

int main() {
  // Initialize an array of integers
  int arr[] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

  // Get the size of the array
  int n = ARRAY_SIZE(arr);

  // Find the minimum element in the array
  int min = find_min(arr, n);

  // Find the maximum element in the array
  int max = find_max(arr, n);

  // Find the average of the array
  double avg = find_avg(arr, n);

  // Sort the array in ascending order
  sort_ascending(arr, n);

  // Sort the array in descending order
  sort_descending(arr, n);

  // Print the original array
  printf("Original array: ");
  print_array(arr, n);

  // Print the minimum element in the array
  printf("Minimum element: %d\n", min);

  // Print the maximum element in the array
  printf("Maximum element: %d\n", max);

  // Print the average of the array
  printf("Average: %.2f\n", avg);

  // Print the array sorted in ascending order
  printf("Array sorted in ascending order: ");
  print_array(arr, n);

  // Print the array sorted in descending order
  printf("Array sorted in descending order: ");
  print_array(arr, n);

  return 0;
}